@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>Users</title>
@endsection

<!-- custom css -->
@section('css')
<style>
    .guide-area {
        display: none;
    }
</style>
@endsection

@section('content')

    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent" style="direction: ltr;">
                        {{-- <h4 class="mb-sm-0">Team</h4> --}}

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"></li>
                                <li class="breadcrumb-item"><a href="{{route('admin/index')}}">Home</a></li>
                                <li class="breadcrumb-item active"><a href="{{route('admin/users/index')}}/0/{{PAGINATION_COUNT}}">Users</a></li>
                                <li class="active" style="color: var(--vz-breadcrumb-item-active-color);">Create</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>

            @include('flash::message')
            @if ($errors->any())
                <div style="text-align: left; margin: 15px;">
                    <ul dir="ltr">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{$error}}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">User Form</h4>
                        </div>
                        <div class="card-body">
                            <form role="form" action="{{url(route('admin/users/create'))}}" method="post" enctype="multipart/form-data">
                                <div class="live-preview">
                                    @csrf
                                    <div class="row gy-4">

                                        <div class="col-xxl-6 col-md-6">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">نوع المستخدم <span class="text-danger">*</span></label><br/>
                                                <select name="user_type" class="form-control" id="user_type">
                                                    <option value="1">عميل</option>
                                                    <option value="2">مرشد سياحي</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6"></div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">الاسم<span class="text-danger">*</span></label><br/>
                                                <input name="name" type="text" class="form-control" id="">
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">الايميل<span class="text-danger">*</span></label><br/>
                                                <input name="email" type="text" class="form-control" id="">
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">رقم الجوال <span class="text-danger">*</span></label><br/>
                                                <input name="mobile" type="text" class="form-control" id="mobileNumberfloatingInput">
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">الصورة الشخصية <span class="text-danger">*</span></label><br/>
                                                <input name="file" type="file" id="filefloatingInput" class="form-control" placeholder="Upload Image">
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">كلمه المرور <span class="text-danger">*</span></label><br/>
                                                <input name="password" type="password" class="form-control" id="namefloatingInput">
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">تاكيد كلمه المرور <span class="text-danger">*</span></label><br/>
                                                <input name="password_confirmation" type="password" class="form-control" id="namefloatingInput">
                                            </div>
                                        </div>
                                        
                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">نبذه <span class="text-danger">*</span></label><br/>
                                                <textarea class="form-control" name="info" aria-label="With textarea" rows="2"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">الخبره <span class="text-danger">*</span></label><br/>
                                                <textarea class="form-control" name="experience" aria-label="With textarea" rows="2"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">سعر الساعه<span class="text-danger">*</span></label><br/>
                                                <input name="hour_price" type="text" class="form-control" id="">
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <div class="form-group">
                                                <label style="margin-bottom: 0px;" for="">سعر اليوم<span class="text-danger">*</span></label><br/>
                                                <input name="day_price" type="text" class="form-control" id="">
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <div class="form-group">
                                                <label style="margin-bottom: 7px;" for="">الدوله <span class="text-danger">*</span></label><br/>
                                                <select name="country_id" id="countries" class="form-control">
                                                    <option value="">---</option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <div class="col-xxl-12 col-md-12">
                                                <div class="form-group">
                                                    <label style="margin-bottom: 7px;" for="">اللغات <span class="text-danger">*</span></label><br/>
                                                    <select name="languages[]" id="languages" class="form-control" multiple>
                                                        <option value="">---</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <button class="btn btn-primary mb-1" id="add-input-interests" type="button" style="background: #2f6bb9;"><i class="bx bx-plus"></i> اضافه اهتمامات</button>
                                        </div>
                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <button class="btn btn-primary mb-1" id="add-input-tours-type" type="button" style="background: #2f6bb9;"><i class="bx bx-plus"></i> اضافه جولات</button>
                                        </div>
                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <div id="interests-area">
                                                <div class="input-container mb-1">
                                                    <div class="row">
                                                        <div class="col-xxl-10 col-md-10">
                                                            <div class="form-floating">
                                                                <input name="interests[]" type="text" class="form-control" id="namefloatingInput" placeholder="interests">
                                                                <label for="namefloatingInput">اهتمامات <span class="text-danger">*</span></label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xxl-2 col-md-2">
                                                            <label for="" class="mb-2"></label>
                                                            <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class=""><i class="bx bx-trash"></i></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xxl-6 col-md-6 guide-area">
                                            <div id="tours-type-area">
                                                <div class="input-container mb-1">
                                                    <div class="row">
                                                        <div class="col-xxl-10 col-md-10">
                                                            <div class="form-floating">
                                                                <input name="tours_type[]" type="text" class="form-control" id="namefloatingInput" placeholder="tours-type">
                                                                <label for="namefloatingInput">جولات <span class="text-danger">*</span></label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xxl-2 col-md-2">
                                                            <label for="" class="mb-2"></label>
                                                            <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class=""><i class="bx bx-trash"></i></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-xxl-12 col-md-12 guide-area">
                                            <div class="input-container input-container-0 mb-3">
                                                <div class="row">
                                                    <div class="col-xxl-3 col-md-3 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput10">السبت <span class="text-danger"></span></label>
                                                            <input name="days[0][day]" type="text" class="form-control" id="namefloatingInput10" value="السبت" placeholder="السبت" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput20">start <span class="text-danger"></span></label>
                                                            <input name="days[0][start]" type="time" class="form-control" id="namefloatingInput20" placeholder="start">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput30">end <span class="text-danger"></span></label>
                                                            <input name="days[0][end]" type="time" class="form-control" id="namefloatingInput30" placeholder="end">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput40">day status <span class="text-danger"></span></label><br>
                                                            <select class="form-control" name="days[0][day_status]">
                                                                <option value="">اختر</option>
                                                                <option value="1">طول اليوم</option>
                                                                <option value="2">اجازه</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="input-container input-container-0 mb-3">
                                                <div class="row">
                                                    <div class="col-xxl-3 col-md-3 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput11">الاحد <span class="text-danger"></span></label>
                                                            <input name="days[1][day]" type="text" class="form-control" id="namefloatingInput11" value="الاحد" placeholder="الاحد" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput21">start <span class="text-danger"></span></label>
                                                            <input name="days[1][start]" type="time" class="form-control" id="namefloatingInput21" placeholder="start">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput31">end <span class="text-danger"></span></label>
                                                            <input name="days[1][end]" type="time" class="form-control" id="namefloatingInput31" placeholder="end">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput41">day status <span class="text-danger"></span></label><br>
                                                            <select class="form-control" name="days[1][day_status]">
                                                                <option value="">اختر</option>
                                                                <option value="1">طول اليوم</option>
                                                                <option value="2">اجازه</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="input-container input-container-0 mb-3">
                                                <div class="row">
                                                    <div class="col-xxl-3 col-md-3 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput12">الاثنين <span class="text-danger"></span></label>
                                                            <input name="days[2][day]" type="text" class="form-control" id="namefloatingInput12" value="الاثنين" placeholder="الاثنين" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput22">start <span class="text-danger"></span></label>
                                                            <input name="days[2][start]" type="time" class="form-control" id="namefloatingInput22" placeholder="start">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput32">end <span class="text-danger"></span></label>
                                                            <input name="days[2][end]" type="time" class="form-control" id="namefloatingInput32" placeholder="end">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput43">day status <span class="text-danger"></span></label><br>
                                                            <select class="form-control" name="days[2][day_status]">
                                                                <option value="">اختر</option>
                                                                <option value="1">طول اليوم</option>
                                                                <option value="2">اجازه</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="input-container input-container-0 mb-3">
                                                <div class="row">
                                                    <div class="col-xxl-3 col-md-3 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput13">الثلاثاء <span class="text-danger"></span></label>
                                                            <input name="days[3][day]" type="text" class="form-control" id="namefloatingInput13" value="الثلاثاء" placeholder="الثلاثاء" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput23">start <span class="text-danger"></span></label>
                                                            <input name="days[3][start]" type="time" class="form-control" id="namefloatingInput23" placeholder="start">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput33">end <span class="text-danger"></span></label>
                                                            <input name="days[3][end]" type="time" class="form-control" id="namefloatingInput33" placeholder="end">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput43">day status <span class="text-danger"></span></label><br>
                                                            <select class="form-control" name="days[3][day_status]">
                                                                <option value="">اختر</option>
                                                                <option value="1">طول اليوم</option>
                                                                <option value="2">اجازه</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="input-container input-container-0 mb-3">
                                                <div class="row">
                                                    <div class="col-xxl-3 col-md-3 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput14">الاربعاء <span class="text-danger"></span></label>
                                                            <input name="days[4][day]" type="text" class="form-control" id="namefloatingInput14" value="الاربعاء" placeholder="الاربعاء" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput24">start <span class="text-danger"></span></label>
                                                            <input name="days[4][start]" type="time" class="form-control" id="namefloatingInput24" placeholder="start">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput34">end <span class="text-danger"></span></label>
                                                            <input name="days[4][end]" type="time" class="form-control" id="namefloatingInput34" placeholder="end">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput44">day status <span class="text-danger"></span></label><br>
                                                            <select class="form-control" name="days[4][day_status]">
                                                                <option value="">اختر</option>
                                                                <option value="1">طول اليوم</option>
                                                                <option value="2">اجازه</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="input-container input-container-0 mb-3">
                                                <div class="row">
                                                    <div class="col-xxl-3 col-md-3 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput15">الخميس <span class="text-danger"></span></label>
                                                            <input name="days[5][day]" type="text" class="form-control" id="namefloatingInput15" value="الخميس" placeholder="الخميس" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput25">start <span class="text-danger"></span></label>
                                                            <input name="days[5][start]" type="time" class="form-control" id="namefloatingInput25" placeholder="start">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput35">end <span class="text-danger"></span></label>
                                                            <input name="days[5][end]" type="time" class="form-control" id="namefloatingInput35" placeholder="end">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput45">day status <span class="text-danger"></span></label><br>
                                                            <select class="form-control" name="days[5][day_status]">
                                                                <option value="">اختر</option>
                                                                <option value="1">طول اليوم</option>
                                                                <option value="2">اجازه</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="input-container input-container-0 mb-3">
                                                <div class="row">
                                                    <div class="col-xxl-3 col-md-3 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput16">الجمعه <span class="text-danger"></span></label>
                                                            <input name="days[6][day]" type="text" class="form-control" id="namefloatingInput16" value="الجمعه" placeholder="الجمعه" readonly>
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput26">start <span class="text-danger"></span></label>
                                                            <input name="days[6][start]" type="time" class="form-control" id="namefloatingInput26" placeholder="start">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput36">end <span class="text-danger"></span></label>
                                                            <input name="days[6][end]" type="time" class="form-control" id="namefloatingInput36" placeholder="end">
                                                        </div>
                                                    </div>
                                                    <div class="col-xxl-2 col-md-2 mb-3">
                                                        <div class="group-form">
                                                            <label for="namefloatingInput46">day status <span class="text-danger"></span></label><br>
                                                            <select class="form-control" name="days[6][day_status]">
                                                                <option value="">اختر</option>
                                                                <option value="1">طول اليوم</option>
                                                                <option value="2">اجازه</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        

                                        <div class="col-12" style="direction: ltr;">
                                            <button class="btn btn-md" style="background-color: #2f6bb9; color: white;" type="submit">اضافه</button>
                                            <button class="btn btn-light" type="reset">الغاء</button>
                                        </div>

                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

@endsection

<!-- custom js -->
@section('script')
<script>
    (function () {
        $('.nav-link.menu-link').removeClass('active');
        $('.menu-dropdown').removeClass('show');
        $('.sidebarusers').addClass('active');
        var target = $('.sidebarusers').attr('href');
        $(target).addClass('show');
    })();
    $('#countries').select2({
        ajax: {
            url: "{{ route('get/countries') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true,
            width: '100%'
        }
    });

    $(document).on('change', '#user_type', function () {
        if ($(this).val() == 1){
            $('.guide-area').hide();
        } else {
            $('.guide-area').show();
        }
    });

    $('#languages').select2({
        ajax: {
            url: "{{ route('get/languages') }}",
            dataType: 'json',
            processResults: function (data) {
                return {
                    results:  $.map(data, function (item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                };
            },
            cache: true,
            width: '100%'
        }
    });

    let inputCount = 10;
    $('#add-input-interests').click(function () {

        inputCount++;
        $('#interests-area').append(`
            <div class="input-container input-container-${inputCount} mb-1">
                <div class="row">
                    <div class="col-xxl-10 col-md-10">
                        <div class="form-floating">
                            <input name="interests[]" type="text" class="form-control" id="namefloatingInput" placeholder="interests">
                            <label for="namefloatingInput">اهتمامات <span class="text-danger">*</span></label>
                        </div>
                    </div>
                    <div class="col-xxl-2 col-md-2">
                        <label for="" class="mb-2"></label>
                        <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-${inputCount}"><i class="bx bx-trash"></i></span>
                    </div>
                </div>
            </div>
        `);
    });
    $('#add-input-tours-type').click(function () {

        inputCount++;
        $('#tours-type-area').append(`
            <div class="input-container input-container-${inputCount} mb-1">
                <div class="row">
                    <div class="col-xxl-10 col-md-10">
                        <div class="form-floating">
                            <input name="tours_type[]" type="text" class="form-control" id="namefloatingInput" placeholder="tours-type">
                            <label for="namefloatingInput">جولات <span class="text-danger">*</span></label>
                        </div>
                    </div>
                    <div class="col-xxl-2 col-md-2">
                        <label for="" class="mb-2"></label>
                        <span class="remove-btn badge bg-danger rounded-pill mt-4" parent-class="input-container-${inputCount}"><i class="bx bx-trash"></i></span>
                    </div>
                </div>
            </div>
        `);
    });
    $(document).on('click', '.remove-btn', function () {
        var parentClass = $(this).attr('parent-class');
        $('.'+parentClass).remove();
    });
</script>
@endsection
