@extends('layouts.admin.home')

<!-- title page -->
@section('title')
    <title>Categories</title>
@endsection

<!-- custom css -->
@section('css')
@endsection

@section('content')

    <div class="page-content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent" style="direction: ltr;">
                        {{-- <h4 class="mb-sm-0">Team</h4> --}}

                        <div class="page-title-right">
                            <ol class="breadcrumb m-0">
                                <li class="breadcrumb-item"></li>
                                <li class="breadcrumb-item"><a href="{{route('admin/index')}}">Home</a></li>
                                <li class="breadcrumb-item active"><a href="{{route('admin/categories/index')}}/0/{{PAGINATION_COUNT}}">Categories</a></li>
                                <li class="active" style="color: var(--vz-breadcrumb-item-active-color);">Create</li>
                            </ol>
                        </div>

                    </div>
                </div>
            </div>

            @include('flash::message')
            @if ($errors->any())
                <div style="text-align: left; margin: 15px;">
                    <ul dir="ltr">
                        @foreach ($errors->all() as $error)
                            <li class="text-danger">{{$error}}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Category Form</h4>
                        </div>
                        <div class="card-body">
                            <form role="form" action="{{url(route('admin/categories/create'))}}" method="post" enctype="multipart/form-data">
                                <div class="live-preview">
                                    @csrf
                                    <div class="row gy-4">

                                        
                                        <div class="card mt-xxl-n5">
                                            <div class="card-header">
                                                <ul class="nav nav-tabs card-header-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active fw-bold" data-bs-toggle="tab" href="#enLang" role="tab" style="border-width: 4px;">
                                                            <span class="text-danger">*</span> البيانات الاساسيه (EN)
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#arLang" role="tab" style="border-width: 4px;">
                                                            AR
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#frLang" role="tab" style="border-width: 4px;">
                                                            FR
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#trLang" role="tab" style="border-width: 4px;">
                                                            TR
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link fw-bold" data-bs-toggle="tab" href="#hiLang" role="tab" style="border-width: 4px;">
                                                            HI
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        

                                            <div class="card-body p-4">
                                                <div class="tab-content">
                                                    
                                                    <div class="tab-pane active" id="enLang" role="tabpanel">
                                                        <div class="row">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name en <span class="text-danger">*</span></label>
                                                                    <input name="name[en]" type="text" class="form-control" id="namefloatingInput" placeholder="name en">
                                                                </div>
                                                            </div>
                                                            <div class="col-xxl-6 col-md-6 mb-3"></div>
                                                            
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="filefloatingInput">img <span class="text-danger">*</span></label>
                                                                    <input name="file" type="file" id="filefloatingInput" class="form-control" placeholder="Upload Image">
                                                                </div>
                                                            </div> 
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="arLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name ar <span class="text-danger"></span></label>
                                                                    <input name="name[ar]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="frLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name fr <span class="text-danger"></span></label>
                                                                    <input name="name[fr]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="trLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name tr <span class="text-danger"></span></label>
                                                                    <input name="name[tr]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                    <!--end tab-pane-->
                                                    <div class="tab-pane" id="hiLang" role="tabpanel">
                                                        <div class="row g-2">
                                                            <div class="col-xxl-6 col-md-6 mb-3">
                                                                <div class="group-form">
                                                                    <label for="namefloatingInput">name hi <span class="text-danger"></span></label>
                                                                    <input name="name[hi]" type="text" class="form-control" id="namefloatingInput" placeholder="name ar">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <button class="btn btn-primary" type="submit">Submit form</button>
                                            <button class="btn btn-success" type="reset">Reset Button</button>
                                        </div>

                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

@endsection

<!-- custom js -->
@section('script')
<script>
    (function () {
        $('.nav-link.menu-link').removeClass('active');
        $('.menu-dropdown').removeClass('show');
        $('.sidebarcategories').addClass('active');
        var target = $('.sidebarcategories').attr('href');
        $(target).addClass('show');
    })();
</script>
@endsection
