// Reveal on scroll + form validation (no external libs except jQuery/Bootstrap)
(function($){
  // Reveal
  function onScrollReveal(){
    $('.reveal').each(function(){
      var $el = $(this);
      if ($el.hasClass('show')) return;
      var rect = this.getBoundingClientRect();
      var inView = rect.top < (window.innerHeight * 0.85) && rect.bottom > 0;
      if(inView){ $el.addClass('show'); }
    });
  }
  $(window).on('scroll resize load', onScrollReveal);
  onScrollReveal();

  // Navbar active link change on scroll (basic)
  var sections = ['about','services','faq','app','contact'];
  function updateActive(){
    var pos = window.scrollY + 120;
    var current = null;
    sections.forEach(function(id){
      var el = document.getElementById(id);
      if(!el) return;
      if(pos >= el.offsetTop){ current = id; }
    });
    $('.navbar .nav-link').removeClass('active');
    if(current){
      $('.navbar .nav-link[href="#'+current+'"]').addClass('active');
    } else {
      $('.navbar .nav-link[href="#"]').addClass('active');
    }
  }
  $(window).on('scroll load', updateActive);

  // Bootstrap validation
  (function(){
    'use strict'
    var forms = document.querySelectorAll('.needs-validation')
    Array.prototype.slice.call(forms).forEach(function (form) {
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault()
          event.stopPropagation()
        }
        form.classList.add('was-validated')
      }, false)
    })
  })()
})(jQuery);
