<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_orders', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->tinyInteger('status')->nullable()->comment('1 => pending, 2 => confirmed, 3 => completed, 4 => canceled, 5 => refunded, 6 => user_confirmed');
            $table->integer('hotel_id')->nullable();
            $table->integer('added_by')->nullable();
            $table->integer('provider_id')->nullable();
            $table->integer('chat_group_id')->nullable();
            $table->integer('trip_id')->nullable();
            $table->date('date_arrive')->nullable();
            $table->date('date_departure')->nullable();
            $table->time('time_arrive')->nullable();
            $table->time('time_departure')->nullable();
            $table->integer('persons_count')->nullable();
            $table->integer('children_count')->nullable();
            $table->string('room', 255)->nullable();
            $table->integer('room_id')->nullable();
            $table->integer('room_price')->nullable();
            $table->integer('cost')->nullable();
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('canceled_by')->nullable()->comment('1 => from provider , 2 => from client');
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_orders');
    }
};
