<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('guide_days_work', function (Blueprint $table) {
            $table->id();
            $table->timestamps();
            $table->string('day', 255)->nullable();
            $table->string('start')->nullable();
            $table->string('end')->nullable();
            $table->tinyInteger('day_status')->nullable()->comment('1 => all day , 2 => vacation');
            $table->integer('guide_id')->nullable();
            $table->dateTime('deleted_at')->nullable();
            $table->tinyInteger('is_activate')->default(1);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('guide_days_work');
    }
};
