<?php
	use Illuminate\Support\Facades\File;

	define('PAGINATION_COUNT', 10);
	define('PAGINATION_COUNT_FRONT', 10);

	function uploadIamge($file, $folder){
		$destinationPath = 'admin/assets/images/' . $folder . '/'; // upload path
		$extension = $file->getClientOriginalExtension(); // getting image extension
        $fileName = time() . rand(11111, 99999) . '.' . $extension;  
		$file_move = $file->move(public_path($destinationPath), $fileName);
		return $destinationPath . $fileName;
	}

	function uploadIamges($files, $folder){
		$images = [];
		foreach ($files as $file){
			$destinationPath = 'admin/assets/images/' . $folder . '/'; // upload path
			$extension = $file->getClientOriginalExtension(); // getting image extension
			$fileName = time() . rand(11111, 99999) . '.' . $extension;  
			$file_move = $file->move(public_path($destinationPath), $fileName);
			$images[] = $destinationPath . $fileName;
		}
		$files = implode(",", $images);
		return $files;
	}

	function responseJson($status, $msg, $data = null)
	{
		$response = [
			'status' => $status,
			'msg' => $msg,
			'data' => $data
		];
		return response()->json($response);
	}

	function orderStatus($status)
	{
		switch ($status) {
			case 1:
				// return 'Pending';
				return '<span style="background: #919191; color: white; padding: 8px 17px; border-radius: 8px;">Pending</span>';
				break;

			case 2:
				// return 'Confirmed';
				return '<span style="background: #2cd259; color: white; padding: 8px 17px; border-radius: 8px;">Confirmed</span>';
				break;

			case 3:
				// return 'Completed';
				return '<span style="background: #2cd259; color: white; padding: 8px 17px; border-radius: 8px;">Completed</span>';
				break;
			
			case 4:
				// return 'Canceled';
				return '<span style="background: #df4747; color: white; padding: 8px 17px; border-radius: 8px;">Canceled</span>';
				break;
				
			case 5:
				// return 'Refunded';
				return '<span style="background: #df4747; color: white; padding: 8px 17px; border-radius: 8px;">Refunded</span>';
				break;

			default:
				// return 'Not Found';
				return '<span style="background: #919191; color: white; padding: 8px 17px; border-radius: 8px;">Not Found</span>';
				break;
		}
	}


    // "autoload": {
    //     "psr-4": {
    //         "App\\": "app/",
    //         "Database\\Factories\\": "database/factories/",
    //         "Database\\Seeders\\": "database/seeders/"
    //     },
    //     "files" : [
    //         "app/helper/functions.php"
    //     ]
    // },