<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Wallet extends Model
{
    protected $table = 'wallets';
	protected $fillable = [
		'typeable_id',
		'typeable_type',
		'group_id',
		'balance',
	];
    public $timestamps = true;

	public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'typeable_id' => '',
			'typeable_type' => '',
			'group_id' => '',
			'balance' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return ['typeable', 'transactions.user'];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function typeable()
    {
        return $this->morphTo();
    }

	public function group()
	{
		return $this->belongsTo(ChatGroup::class, 'group_id');
	}

	public function transactions()
	{
		return $this->hasMany(WalletTransaction::class, 'wallet_id');
	}

	public function deposit_transactions()
	{
		return $this->hasMany(WalletTransaction::class, 'wallet_id')->where('type', 1)->where('status', 1);
	}

	public function withdraw_transactions()
	{
		return $this->hasMany(WalletTransaction::class, 'wallet_id')->where('type', 2)->where('status', 1);
	}

	public function user_deposit_transactions()
	{
		return $this->hasMany(WalletTransaction::class, 'wallet_id')->where('type', 1)->where('status', 1)->where('user_id', auth()->user()->id);
	}

	public function user_withdraw_transactions()
	{
		return $this->hasMany(WalletTransaction::class, 'wallet_id')->where('type', 2)->where('status', 1)->where('user_id', auth()->user()->id);
	}

	public function user_withdraw_transactions_requests()
	{
		return $this->hasMany(WalletTransaction::class, 'wallet_id')->where('type', 2)->where('status', 0)->where('user_id', auth()->user()->id);
	}

}