<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class ChatGroup extends Model
{
    protected $table = 'chat_groups';
	protected $fillable = [
		'name',
		'img',
		'destination',
		'added_by_id',
	];
    public $timestamps = true;

	public static function boot()
	{
		parent::boot();
		static::created(function ($chatGroup) {
			$chatGroup->wallet()->create(['balance' => 0]);
		});
	}

	public function scopeActive($query){
		return $query->where('is_activate', 1);
	}
	
	public function scopeUnActive($query){
		return $query->where('is_activate', 0);
	}

	public function scopeArchive($query){
		return $query->whereNotNull('deleted_at');
	}
	
	public function scopeUnArchive($query){
		return $query->whereNull('deleted_at');
	}
	
	public function fildes(){
		return [
			'name' => '',
			'img' => '',
			'destination' => '',
			'added_by_id' => '',
		];
	}

	public function scopeModelSearch($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function scopeModelSearchInArchives($model, $query)
	{
		return $model->latest()->where('id', 'LIKE', '%'. $query .'%')
					 ->orWhere('name', 'LIKE', '%'. $query .'%')
					 ->limit(PAGINATION_COUNT);
	}

	public function model_relations()
	{
		return [];
	}

	public function model_relations_counts()
	{
		return [];
	}

	public function added_by()
	{
		return $this->belongsTo(User::class, 'added_by_id');
	}

	public function members()
	{
		return $this->hasMany(ChatGroupMember::class, 'group_id');
	}

	public function messages()
	{
		return $this->hasMany(ChatGroupMessage::class, 'group_id');
	}

	public function last_message()
	{
		return $this->hasOne(ChatGroupMessage::class, 'group_id')->latest();
	}
	    
	public function unreadMessages()
    {
        $userId = auth()->id();
        return $this->messages()->where('is_activate', 1)->whereDoesntHave('readers', fn ($q) => $q->where('users.id', $userId));
    }

	public function media()
	{
		return $this->hasMany(ChatGroupMedia::class, 'group_id');
	}
	
	public function wallet_old()
	{
		return $this->hasOne(Wallet::class, 'group_id');
	}

	public function trips()
	{
		return $this->hasMany(Trip::class, 'chat_group_id');
	}

	public function car_orders()
	{
		return $this->hasMany(CarOrder::class, 'chat_group_id');
	}

	public function cafe_orders()
	{
		return $this->hasMany(CafeOrder::class, 'chat_group_id');
	}

	public function hotel_orders()
	{
		return $this->hasMany(HotelOrder::class, 'chat_group_id');
	}

	public function guide_orders()
	{
		return $this->hasMany(GuideOrder::class, 'chat_group_id');
	}

	public function restaurant_orders()
	{
		return $this->hasMany(RestaurantOrder::class, 'chat_group_id');
	}

	public function wallet()
    {
        return $this->morphOne(Wallet::class, 'typeable');
    }

	public function transactions()
	{
		return $this->hasMany(WalletTransaction::class, 'chat_group_id');
	}

}