<?php

namespace App\Http\Requests\Api\UserRequesrs;

use Illuminate\Foundation\Http\FormRequest;

class StoreGuideOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'chat_group_id' => 'nullable|exists:chat_groups,id',
            'guide_id' => 'required|exists:users,id',
            'date' => 'required|date_format:Y-m-d',
            'day' => 'required|string|max:255',
            'time' => 'required_if:reservation_type,2|string|max:255',
            'reservation_type' => 'required|in:1,2',
        ];
    }
}
