<?php

namespace App\Http\Requests\Admin\LanguageRequests;

use Illuminate\Foundation\Http\FormRequest;

class LanguageStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            // 'name' => 'required|string|max:254|unique:languages,name'
            // 'name.en' => 'required|string|max:254|unique:language_translations,name,' . $id . ',language_id,locale,en'

            'name.en' => 'required|string|max:254|unique:language_translations,name,NULL,id,locale,en',
            'name.ar' => 'nullable|string|max:254|unique:language_translations,name,NULL,id,locale,ar',
            'name.fr' => 'nullable|string|max:254|unique:language_translations,name,NULL,id,locale,fr',
            'name.tr' => 'nullable|string|max:254|unique:language_translations,name,NULL,id,locale,tr',
            'name.hi' => 'nullable|string|max:254|unique:language_translations,name,NULL,id,locale,hi',

        ];
    }
}
