<?php

namespace App\Http\Requests\Admin\CategoryRequests;

use Illuminate\Foundation\Http\FormRequest;

class CategoryUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = $this->route('id'); // get from route
        // $id = $this->request->get('user_id'); // get from in blade
        return [
            'file' => 'nullable|image|mimes:jpeg,png,jpg,gif',
            'name.en' => 'required|string|max:254|unique:category_translations,name,' . $id . ',category_id,locale,en',
            'name.ar' => 'nullable|string|max:254|unique:category_translations,name,' . $id . ',category_id,locale,ar',
            'name.fr' => 'nullable|string|max:254|unique:category_translations,name,' . $id . ',category_id,locale,fr',
            'name.tr' => 'nullable|string|max:254|unique:category_translations,name,' . $id . ',category_id,locale,tr',
            'name.hi' => 'nullable|string|max:254|unique:category_translations,name,' . $id . ',category_id,locale,hi',
        ];
    }
}
