<?php

namespace App\Http\Requests\Admin\CarRequests;

use Illuminate\Foundation\Http\FormRequest;

class CarUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = $this->route('id'); // get from route
        // $id = $this->request->get('user_id'); // get from in blade
        return [
            'name.en' => 'required|string|max:254|unique:car_translations,name,' . $id . ',car_id,locale,en',
            'name.ar' => 'nullable|string|max:254|unique:car_translations,name,' . $id . ',car_id,locale,ar',
            'name.fr' => 'nullable|string|max:254|unique:car_translations,name,' . $id . ',car_id,locale,fr',
            'name.tr' => 'nullable|string|max:254|unique:car_translations,name,' . $id . ',car_id,locale,tr',
            'name.hi' => 'nullable|string|max:254|unique:car_translations,name,' . $id . ',car_id,locale,hi',
            
            'file' => 'nullable|image|mimes:jpeg,png,jpg,gif',
            'price' => 'required|max:255',
            'offer' => 'nullable|max:255',
            // 'mobile' => 'required|max:255',
            'persons_count' => 'required|max:255',
            // 'owner' => 'required|string|max:255',
            'country_id' => 'required|exists:countries,id',
            'owner_id' => 'nullable|exists:users,id',
            
            'attributes' => 'nullable|array',
            'attributes.*' => 'required|string|max:100',
        ];
    }
}
