<?php

namespace App\Http\Repositories\Eloquent\Admin;

use App\Models\Option;
use DevxPackage\AbstractRepository;

class OptionRepository extends AbstractRepository
{

    protected $model;

    public function __construct(Option $model)
    {
        $this->model = $model;
    }

    public function crudName(): string
    {
        return 'options';
    }

    public function index($offset, $limit)
    {
        $options = $this->pagination($offset, $limit);
        return view('admin.options.index', compact('options'));
    }

    public function pagination($offset, $limit)
    {
        return $this->model->with($this->model->model_relations())->withCount($this->model->model_relations_counts())->unArchive()->orderBy('id', 'DESC')->paginate(PAGINATION_COUNT);
    }

    public function create()
    {
        return view('admin.options.create');
    }

    public function edit($id)
    {
        $option = $this->findOne($id);
        return view('admin.options.update', compact('option'));
    }

    public function archivesPage($offset, $limit)
    {
        $options = $this->archives($offset, $limit);
        return view('admin.options.archives', compact('options'));
    }

}