<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\RoomRepository;
use App\Http\Requests\Admin\RoomRequests\RoomStoreRequest;
use App\Http\Requests\Admin\RoomRequests\RoomUpdateRequest;

class RoomController extends Controller
{

    public $rooms;

    public function __construct(RoomRepository $rooms)
    {
        $this->rooms = $rooms;
    }

    public function index($offset, $limit)
    {
        try{
            return $this->rooms->index($offset, $limit);
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->rooms->create();
    }

    public function store(RoomStoreRequest $request)
    {
        try{
            $this->rooms->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        return $this->rooms->edit($id);
    }

    public function update(RoomUpdateRequest $request, $id)
    {
        try{
            $this->rooms->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->rooms->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->rooms->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->rooms->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->rooms->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->rooms->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->rooms->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->rooms->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->rooms->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->rooms->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->rooms->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}