<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Repositories\Eloquent\Admin\RestaurantRepository;
use App\Http\Requests\Admin\RestaurantRequests\RestaurantStoreRequest;
use App\Http\Requests\Admin\RestaurantRequests\RestaurantUpdateRequest;

class RestaurantController extends Controller
{

    public $restaurants;

    public function __construct(RestaurantRepository $restaurants)
    {
        $this->restaurants = $restaurants;
    }

    public function index($offset, $limit)
    {
        try{
            $restaurants = $this->restaurants->index($offset, $limit);
            return view('admin.restaurants.index', compact('restaurants'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function create()
    {
        return $this->restaurants->create();
    }

    public function store(RestaurantStoreRequest $request)
    {
        // dd($request->times[0]['time'], \Carbon\Carbon::createFromFormat('H:i', $request->times[0]['time'])->format('h:i A'));
        try{
            $this->restaurants->store($request);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function edit($id)
    {
        return $this->restaurants->edit($id);
    }

    public function update(RestaurantUpdateRequest $request, $id)
    {
        try{
            $this->restaurants->update($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function activate(Request $request)
    {
        try{
            $this->restaurants->activate($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function delete(Request $request)
    {
        try{
            $this->restaurants->delete($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function search(Request $request)
    {
        return $this->restaurants->search($request);
    }

    public function searchByColumn(Request $request)
    {
        return $this->restaurants->searchByColumn($request);
    }

    public function pagination($offset, $limit)
    {
        return $this->restaurants->pagination($offset, $limit);
    }

    public function archives($offset, $limit)
    {
        return $this->restaurants->archivesPage($offset, $limit);
    }

    public function archivesPagination($offset, $limit)
    {
        return $this->restaurants->archives($offset, $limit);
    }

    public function archivesSearch(Request $request)
    {
        return $this->restaurants->archivesSearch($request);
    }

    public function archivesSearchByColumn(Request $request)
    {
        return $this->restaurants->archivesSearchByColumn($request);
    }


    public function back(Request $request)
    {
        try{
            $this->restaurants->back($request->record_id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function uploadAlbums(Request $request, $id)
    {
        try{
            return $this->restaurants->uploadAlbums($request, $id);
        }catch(\Exception $e){
            // return response()->json(['error' => $e], 400);
            return response()->json(['error' => 'There Is Something Wrong, Please Contact Technical Support'], 400);
        }
    }

    public function deleteImg(Request $request, $id)
    {
        try{
            $this->restaurants->deleteImg($request, $id);
            flash()->success('Success');
            return back();
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

    public function orders($offset, $limit)
    {
        try{
            $orders = $this->restaurants->orders($offset, $limit);
            return view('admin.restaurants.orders', compact('orders'));
        }catch(\Exception $e){
            flash()->error('There is something wrong , please contact technical support');
            return back();
        }
    }

}